/*
 * Decompiled with CFR 0.152.
 */
package com.zheng.tts;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class TtsSynthesizerApp
extends JFrame {
    private Mode currentMode = Mode.SIMPLE;
    private JTextArea inputTextArea;
    private JLabel charCountLabel;
    private JTextField accessKeyField;
    private JComboBox<String> languageComboBox;
    private JComboBox<SpeakerItem> speakerComboBox;
    private JTextField directoryField;
    private JButton synthesizeButton;
    private JTextArea logTextArea;
    private JRadioButton simpleModeRadio;
    private JRadioButton batchModeRadio;
    private final OkHttpClient httpClient = new OkHttpClient();
    private final ObjectMapper objectMapper = new ObjectMapper();
    private static final String API_BASE_URL = "https://textreadtts.com/tts/convert";
    private static final DateTimeFormatter FILENAME_FORMATTER = DateTimeFormatter.ofPattern("yyyyMMdd_HHmmss");
    private static final String LANGUAGE_MAP_FILE = "language_map.json";
    private static final String SPEAKER_MAP_FILE = "speaker_map.json";
    private static final Font UI_FONT = new Font("Microsoft YaHei", 1, 14);
    private final Map<String, String> LANGUAGES = new LinkedHashMap<String, String>();
    private Map<String, List<SpeakerItem>> speakerMap = new HashMap<String, List<SpeakerItem>>();

    public TtsSynthesizerApp() {
        this.initializeLanguages();
        this.initializeSpeakerMap();
        this.setTitle("TTS \u6587\u672c\u8f6c\u8bed\u97f3\u5408\u6210\u5de5\u5177");
        this.setDefaultCloseOperation(3);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout(10, 10));
        JPanel controlPanel = new JPanel();
        controlPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.anchor = 17;
        int row = 0;
        gbc.gridy = row++;
        gbc.gridx = 0;
        gbc.weightx = 0.0;
        JLabel modeLabel = new JLabel("\u6a21\u5f0f (Mode):");
        this.setTextComponentFont(modeLabel);
        controlPanel.add((Component)modeLabel, gbc);
        gbc.gridx = 1;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        JPanel radioPanel = new JPanel(new FlowLayout(0, 10, 0));
        this.simpleModeRadio = new JRadioButton("\u7b80\u5355\u6a21\u5f0f", true);
        this.batchModeRadio = new JRadioButton("\u6279\u91cf\u6a21\u5f0f", false);
        this.setTextComponentFont(this.simpleModeRadio);
        this.setTextComponentFont(this.batchModeRadio);
        ButtonGroup modeGroup = new ButtonGroup();
        modeGroup.add(this.simpleModeRadio);
        modeGroup.add(this.batchModeRadio);
        this.simpleModeRadio.addActionListener(e -> {
            this.currentMode = Mode.SIMPLE;
            String appendToLog = this.appendToLog("INFO: \u6a21\u5f0f\u5207\u6362\u4e3a [\u7b80\u5355\u6a21\u5f0f] (\u4e00\u6b21\u8bf7\u6c42\u53d1\u9001\u5168\u90e8\u6587\u672c)");
            this.writeLogToFile(appendToLog);
        });
        this.batchModeRadio.addActionListener(e -> {
            this.currentMode = Mode.BATCH;
            String appendToLog = this.appendToLog("INFO: \u6a21\u5f0f\u5207\u6362\u4e3a [\u6279\u91cf\u6a21\u5f0f] (\u6309\u884c\u5206\u9694\uff0c\u6bcf\u884c\u4e00\u6b21\u8bf7\u6c42)");
            this.writeLogToFile(appendToLog);
        });
        radioPanel.add(this.simpleModeRadio);
        radioPanel.add(this.batchModeRadio);
        controlPanel.add((Component)radioPanel, gbc);
        gbc.gridx = 2;
        controlPanel.add((Component)new JLabel(""), gbc);
        gbc.gridy = row++;
        gbc.gridx = 0;
        gbc.weightx = 0.0;
        JLabel textLabel = new JLabel("\u6587\u672c (Text):");
        this.setTextComponentFont(textLabel);
        controlPanel.add((Component)textLabel, gbc);
        gbc.gridx = 1;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        this.inputTextArea = new JTextArea(3, 30);
        this.setTextComponentFont(this.inputTextArea);
        this.inputTextArea.setLineWrap(true);
        JScrollPane textScrollPane = new JScrollPane(this.inputTextArea);
        int preferredHeight = this.inputTextArea.getFontMetrics(UI_FONT).getHeight() * 6;
        textScrollPane.setPreferredSize(new Dimension(300, preferredHeight));
        textScrollPane.setMinimumSize(new Dimension(200, preferredHeight));
        controlPanel.add((Component)textScrollPane, gbc);
        gbc.gridx = 2;
        gbc.weightx = 0.0;
        gbc.fill = 0;
        this.charCountLabel = new JLabel("\u5b57\u7b26\u6570: 0");
        this.setTextComponentFont(this.charCountLabel);
        this.charCountLabel.setPreferredSize(new Dimension(80, 20));
        controlPanel.add((Component)this.charCountLabel, gbc);
        this.inputTextArea.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                TtsSynthesizerApp.this.updateCharCount();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                TtsSynthesizerApp.this.updateCharCount();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                TtsSynthesizerApp.this.updateCharCount();
            }
        });
        gbc.gridy = row++;
        gbc.gridx = 0;
        gbc.weightx = 0.0;
        JLabel accessKeyLabel = new JLabel("\u8d26\u53f7 (AccessKey):");
        this.setTextComponentFont(accessKeyLabel);
        controlPanel.add((Component)accessKeyLabel, gbc);
        gbc.gridx = 1;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        this.accessKeyField = new JTextField("FREE", 15);
        this.setTextComponentFont(this.accessKeyField);
        controlPanel.add((Component)this.accessKeyField, gbc);
        gbc.gridx = 2;
        controlPanel.add((Component)new JLabel(""), gbc);
        gbc.gridy = row++;
        gbc.gridx = 0;
        gbc.weightx = 0.0;
        JLabel languageLabel = new JLabel("\u8bed\u8a00 (Language):");
        this.setTextComponentFont(languageLabel);
        controlPanel.add((Component)languageLabel, gbc);
        gbc.gridx = 1;
        gbc.weightx = 1.0;
        this.languageComboBox = new JComboBox<String>(this.LANGUAGES.keySet().toArray(new String[0]));
        this.setTextComponentFont(this.languageComboBox);
        if (this.LANGUAGES.containsKey("\u82f1\u8bed (English)")) {
            this.languageComboBox.setSelectedItem("\u82f1\u8bed (English)");
        } else if (this.languageComboBox.getItemCount() > 0) {
            this.languageComboBox.setSelectedIndex(0);
        }
        this.languageComboBox.addActionListener(e -> this.updateSpeakers());
        controlPanel.add(this.languageComboBox, gbc);
        gbc.gridx = 2;
        controlPanel.add((Component)new JLabel(""), gbc);
        gbc.gridy = row++;
        gbc.gridx = 0;
        gbc.weightx = 0.0;
        JLabel speakerLabel = new JLabel("\u6717\u8bfb\u8005 (Speaker):");
        this.setTextComponentFont(speakerLabel);
        controlPanel.add((Component)speakerLabel, gbc);
        gbc.gridx = 1;
        gbc.weightx = 1.0;
        this.speakerComboBox = new JComboBox();
        this.setTextComponentFont(this.speakerComboBox);
        controlPanel.add(this.speakerComboBox, gbc);
        gbc.gridx = 2;
        controlPanel.add((Component)new JLabel(""), gbc);
        gbc.gridy = row++;
        gbc.gridx = 0;
        gbc.weightx = 0.0;
        JLabel dirLabel = new JLabel("\u4fdd\u5b58\u76ee\u5f55:");
        this.setTextComponentFont(dirLabel);
        controlPanel.add((Component)dirLabel, gbc);
        gbc.gridx = 1;
        gbc.weightx = 1.0;
        this.directoryField = new JTextField(System.getProperty("user.home"));
        this.setTextComponentFont(this.directoryField);
        this.directoryField.setEditable(false);
        controlPanel.add((Component)this.directoryField, gbc);
        gbc.gridx = 2;
        gbc.weightx = 0.0;
        JButton browseButton = new JButton("\u6d4f\u89c8");
        this.setTextComponentFont(browseButton);
        browseButton.addActionListener(e -> this.selectDirectory());
        controlPanel.add((Component)browseButton, gbc);
        gbc.gridy = row++;
        gbc.gridx = 0;
        gbc.gridwidth = 3;
        gbc.fill = 2;
        this.synthesizeButton = new JButton("\u5408\u6210 (Synthesize)");
        this.setTextComponentFont(this.synthesizeButton);
        this.synthesizeButton.addActionListener(this::synthesizeAction);
        controlPanel.add((Component)this.synthesizeButton, gbc);
        contentPane.add((Component)controlPanel, "North");
        this.logTextArea = new JTextArea();
        this.setTextComponentFont(this.logTextArea);
        this.logTextArea.setEditable(false);
        this.logTextArea.setBackground(new Color(240, 240, 240));
        JScrollPane logScrollPane = new JScrollPane(this.logTextArea);
        JPanel logPanel = new JPanel(new BorderLayout());
        logPanel.setBorder(BorderFactory.createTitledBorder("\u65e5\u5fd7\u8f93\u51fa (Log Output)"));
        logPanel.setPreferredSize(new Dimension(550, 200));
        logPanel.add((Component)logScrollPane, "Center");
        contentPane.add((Component)logPanel, "Center");
        JPanel linkPanel = new JPanel();
        linkPanel.setLayout(new BoxLayout(linkPanel, 1));
        linkPanel.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        JLabel websiteLabel = new JLabel("<html>\u7f51\u7ad9\uff1a<a href=\"https://textreadtts.com/\">https://textreadtts.com/</a></html>");
        this.setTextComponentFont(websiteLabel);
        websiteLabel.setCursor(new Cursor(12));
        websiteLabel.setAlignmentX(0.5f);
        websiteLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                try {
                    if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
                        Desktop.getDesktop().browse(new URI("https://textreadtts.com/"));
                    } else {
                        String appendToLog = TtsSynthesizerApp.this.appendToLog("ERROR: \u5f53\u524d\u7cfb\u7edf\u4e0d\u652f\u6301\u81ea\u52a8\u6253\u5f00\u6d4f\u89c8\u5668\u3002\u8bf7\u624b\u52a8\u8bbf\u95ee\u7f51\u5740\u3002");
                        TtsSynthesizerApp.this.writeLogToFile(appendToLog);
                    }
                }
                catch (Exception ex) {
                    String appendToLog = TtsSynthesizerApp.this.appendToLog("ERROR: \u6253\u5f00\u94fe\u63a5\u5931\u8d25: " + ex.getMessage());
                    TtsSynthesizerApp.this.writeLogToFile(appendToLog);
                }
            }
        });
        JLabel contactLabel = new JLabel("\u8d2d\u4e70\u8d26\u53f7\u8bf7\u8054\u7cfb\u5fae\u4fe1 13146556570");
        this.setTextComponentFont(contactLabel);
        contactLabel.setAlignmentX(0.5f);
        linkPanel.add(websiteLabel);
        linkPanel.add(contactLabel);
        contentPane.add((Component)linkPanel, "South");
        this.pack();
        this.setLocationRelativeTo(null);
        this.updateSpeakers();
    }

    private void initializeLanguages() {
        try (InputStream is = this.getClass().getClassLoader().getResourceAsStream(LANGUAGE_MAP_FILE);){
            if (is == null) {
                System.err.println("\u9519\u8bef\uff1a\u672a\u627e\u5230\u8d44\u6e90\u6587\u4ef6: language_map.json\u3002\u8bf7\u786e\u4fdd\u6587\u4ef6\u5728 src/main/resources \u76ee\u5f55\u4e0b\u3002");
                return;
            }
            JsonNode rootNode = this.objectMapper.readTree(is);
            for (Map.Entry field : () -> rootNode.fields()) {
                this.LANGUAGES.put((String)field.getKey(), ((JsonNode)field.getValue()).asText());
            }
            String appendToLog = this.appendToLog("INFO: Language \u6620\u5c04\u6570\u636e\u4ece\u8d44\u6e90\u6587\u4ef6\u52a0\u8f7d\u6210\u529f\u3002");
            this.writeLogToFile(appendToLog);
        }
        catch (IOException e) {
            System.err.println("\u9519\u8bef\uff1a\u52a0\u8f7d\u6216\u89e3\u6790 Language \u6620\u5c04 JSON \u5931\u8d25: " + e.getMessage());
        }
    }

    private void initializeSpeakerMap() {
        try (InputStream is = this.getClass().getClassLoader().getResourceAsStream(SPEAKER_MAP_FILE);){
            if (is == null) {
                System.err.println("\u9519\u8bef\uff1a\u672a\u627e\u5230\u8d44\u6e90\u6587\u4ef6: speaker_map.json\u3002\u8bf7\u786e\u4fdd\u6587\u4ef6\u5728 src/main/resources \u76ee\u5f55\u4e0b\u3002");
                this.speakerMap = new HashMap<String, List<SpeakerItem>>();
                return;
            }
            JsonNode rootNode = this.objectMapper.readTree(is);
            for (Map.Entry field : () -> rootNode.fields()) {
                String languageKey = (String)field.getKey();
                JsonNode speakersArray = (JsonNode)field.getValue();
                ArrayList<SpeakerItem> speakerList = new ArrayList<SpeakerItem>();
                if (speakersArray.isArray()) {
                    for (JsonNode speakerNode : speakersArray) {
                        String displayName = speakerNode.path("displayName").asText();
                        String value = speakerNode.path("value").asText();
                        if (value.isEmpty()) continue;
                        speakerList.add(new SpeakerItem(displayName, value));
                    }
                }
                this.speakerMap.put(languageKey, speakerList);
            }
            String appendToLog = this.appendToLog("INFO: Speaker \u6620\u5c04\u6570\u636e\u4ece\u8d44\u6e90\u6587\u4ef6\u52a0\u8f7d\u6210\u529f\u3002");
            this.writeLogToFile(appendToLog);
        }
        catch (IOException e) {
            System.err.println("\u9519\u8bef\uff1a\u52a0\u8f7d\u6216\u89e3\u6790 Speaker \u6620\u5c04 JSON \u5931\u8d25: " + e.getMessage());
            this.speakerMap = new HashMap<String, List<SpeakerItem>>();
        }
    }

    private void updateSpeakers() {
        String selectedDisplayLanguage = (String)this.languageComboBox.getSelectedItem();
        String languageParam = this.LANGUAGES.get(selectedDisplayLanguage);
        if (languageParam == null) {
            return;
        }
        List<SpeakerItem> speakers = this.speakerMap.get(languageParam);
        DefaultComboBoxModel<SpeakerItem> model = new DefaultComboBoxModel<SpeakerItem>();
        if (speakers != null && !speakers.isEmpty()) {
            for (SpeakerItem speaker : speakers) {
                model.addElement(speaker);
            }
        } else {
            model.addElement(new SpeakerItem("\u65e0\u53ef\u7528\u6717\u8bfb\u8005", ""));
        }
        this.speakerComboBox.setModel(model);
    }

    private void setTextComponentFont(JComponent component) {
        component.setFont(UI_FONT);
    }

    private void selectDirectory() {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setFileSelectionMode(1);
        int result = fileChooser.showOpenDialog(this);
        if (result == 0) {
            File selectedFile = fileChooser.getSelectedFile();
            this.directoryField.setText(selectedFile.getAbsolutePath());
        }
    }

    private void updateCharCount() {
        int count = this.inputTextArea.getText().length();
        this.charCountLabel.setText("\u5b57\u7b26\u6570: " + count);
    }

    private void writeLogToFile(String logContent) {
        if (this.directoryField == null) {
            return;
        }
        String dirPath = this.directoryField.getText();
        if (dirPath.isEmpty()) {
            this.appendToLog("\u8b66\u544a: \u672a\u6307\u5b9a\u65e5\u5fd7\u76ee\u5f55\uff0c\u8df3\u8fc7\u6587\u4ef6\u5199\u5165\u3002");
            return;
        }
        File logDir = new File(dirPath);
        if (!logDir.exists() || !logDir.isDirectory()) {
            this.appendToLog("\u9519\u8bef: \u6307\u5b9a\u7684\u65e5\u5fd7\u76ee\u5f55\u65e0\u6548\u6216\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u5199\u5165\u3002");
            return;
        }
        String fileName = "TtsSynthesizerApp.log";
        File logFile = new File(logDir, fileName);
        try (FileWriter writer = new FileWriter(logFile, StandardCharsets.UTF_8, true);){
            writer.write(logContent);
            this.appendToLog("INFO: \u65e5\u5fd7\u5df2\u6210\u529f\u4fdd\u5b58\u5230: " + logFile.getAbsolutePath());
        }
        catch (IOException ex) {
            this.appendToLog("ERROR: \u5199\u5165\u65e5\u5fd7\u6587\u4ef6\u5931\u8d25\uff01" + ex.getMessage());
        }
    }

    private void downloadFile(String fileUrl, String directoryPath, String originalText, int lineNumber) {
        File dir = new File(directoryPath);
        if (!dir.exists() || !dir.isDirectory()) {
            SwingUtilities.invokeLater(() -> {
                String appendToLog = this.appendToLog("ERROR: [\u884c " + (lineNumber + 1) + "] \u4fdd\u5b58\u76ee\u5f55\u65e0\u6548\u6216\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u4e0b\u8f7d MP3\u3002");
                this.writeLogToFile(appendToLog);
            });
            return;
        }
        Request downloadRequest = new Request.Builder().url(fileUrl).build();
        try (Response response = this.httpClient.newCall(downloadRequest).execute();){
            Object fileName;
            if (!response.isSuccessful()) {
                SwingUtilities.invokeLater(() -> {
                    String appendToLog = this.appendToLog("ERROR: [\u884c " + (lineNumber + 1) + "] MP3 \u4e0b\u8f7d\u8bf7\u6c42\u5931\u8d25! \u54cd\u5e94\u7801: " + response.code());
                    this.writeLogToFile(appendToLog);
                });
                return;
            }
            try {
                String urlPath = new URL(fileUrl).getPath();
                fileName = urlPath.substring(urlPath.lastIndexOf(47) + 1);
                if (!((String)fileName).toLowerCase().endsWith(".mp3")) {
                    fileName = "TTS_" + LocalDateTime.now().format(FILENAME_FORMATTER) + ".mp3";
                }
            }
            catch (Exception e) {
                fileName = "TTS_" + LocalDateTime.now().format(FILENAME_FORMATTER) + ".mp3";
            }
            if (this.currentMode == Mode.BATCH) {
                fileName = String.format("%04d-%s", lineNumber + 1, fileName);
            }
            Path targetPath = Paths.get(directoryPath, new String[]{fileName});
            try (ResponseBody body = response.body();
                 InputStream inputStream2 = body.byteStream();){
                Files.copy(inputStream2, targetPath, StandardCopyOption.REPLACE_EXISTING);
                SwingUtilities.invokeLater(() -> {
                    String appendToLog = this.appendToLog("SUCCESS: [\u884c " + (lineNumber + 1) + "] MP3 \u6587\u4ef6\u5df2\u4fdd\u5b58\u5230: " + targetPath.toAbsolutePath().toString());
                    this.writeLogToFile(appendToLog);
                });
            }
            catch (IOException ex) {
                SwingUtilities.invokeLater(() -> {
                    String appendToLog = this.appendToLog("ERROR: [\u884c " + (lineNumber + 1) + "] \u4fdd\u5b58 MP3 \u6587\u4ef6\u65f6\u53d1\u751f\u5f02\u5e38\uff01" + ex.getMessage());
                    this.writeLogToFile(appendToLog);
                });
            }
        }
        catch (IOException ex) {
            SwingUtilities.invokeLater(() -> {
                String appendToLog = this.appendToLog("ERROR: [\u884c " + (lineNumber + 1) + "] MP3 \u4e0b\u8f7d\u8bf7\u6c42\u5931\u8d25\uff01" + ex.getMessage());
                this.writeLogToFile(appendToLog);
            });
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean sendTtsRequestSync(String text, String accessKey, String languageParam, String speakerValue, int lineNumber, StringBuilder sessionLog) {
        String prefix = this.currentMode == Mode.BATCH ? "[\u884c " + (lineNumber + 1) + "] " : "";
        try {
            String encodedText = URLEncoder.encode(text, StandardCharsets.UTF_8.toString());
            String requestUrl = String.format("%s?accessKey=%s&language=%s&speaker=%s&text=%s", API_BASE_URL, URLEncoder.encode(accessKey, StandardCharsets.UTF_8.toString()), languageParam, speakerValue, encodedText);
            sessionLog.append(this.appendToLog(prefix + "\u6b63\u5728\u53d1\u9001\u8bf7\u6c42..."));
            if (this.currentMode == Mode.SIMPLE) {
                sessionLog.append(this.appendToLog(prefix + "URL: " + requestUrl));
            }
            Request request = new Request.Builder().url(requestUrl).get().build();
            try (Response response = this.httpClient.newCall(request).execute();){
                String responseBody = response.body() != null ? response.body().string() : "No response body.";
                sessionLog.append(this.appendToLog(prefix + "Response Code: " + response.code()));
                if (this.currentMode == Mode.SIMPLE) {
                    sessionLog.append(this.appendToLog("\n--- API \u54cd\u5e94\u5185\u5bb9 ---\n" + responseBody));
                }
                if (!response.isSuccessful() && response.code() >= 500) {
                    throw new IOException("Server error: HTTP " + response.code());
                }
                JsonNode rootNode = this.objectMapper.readTree(responseBody);
                int code = rootNode.path("code").asInt();
                String audioUrl = rootNode.path("audio").asText();
                if (code == 0 && audioUrl != null && !audioUrl.isEmpty()) {
                    String appendToLog = this.appendToLog(prefix + "INFO: \u89e3\u6790\u6210\u529f\uff0c\u5f00\u59cb\u4e0b\u8f7d MP3 \u6587\u4ef6...");
                    this.writeLogToFile(appendToLog);
                    this.downloadFile(audioUrl, this.directoryField.getText(), text, lineNumber);
                    boolean bl = true;
                    return bl;
                }
                String message = rootNode.path("message").asText("\u672a\u77e5\u9519\u8bef");
                String appendToLog = this.appendToLog(prefix + "ERROR: TTS \u63a5\u53e3\u8fd4\u56de\u9519\u8bef: " + message + " (\u6587\u672c: " + text.substring(0, Math.min(20, text.length())) + "...)");
                this.writeLogToFile(appendToLog);
                boolean bl = true;
                return bl;
            }
            catch (IOException ex) {
                String errMsg = this.appendToLog(prefix + "ERROR: TTS \u8bf7\u6c42\u5931\u8d25\uff01\n" + ex.getMessage());
                sessionLog.append(errMsg);
                return false;
            }
        }
        catch (Exception ex) {
            String errMsg = this.appendToLog(prefix + "ERROR: \u6784\u5efa\u8bf7\u6c42\u65f6\u53d1\u751f\u5f02\u5e38\uff01\n" + ex.getMessage());
            sessionLog.append(errMsg);
            return false;
        }
    }

    private void synthesizeAction(ActionEvent e) {
        this.synthesizeButton.setEnabled(false);
        this.logTextArea.setText("");
        String fullText = this.inputTextArea.getText();
        String accessKey = this.accessKeyField.getText().trim();
        String selectedDisplayLanguage = (String)this.languageComboBox.getSelectedItem();
        String languageParam = this.LANGUAGES.get(selectedDisplayLanguage);
        SpeakerItem selectedSpeakerItem = (SpeakerItem)this.speakerComboBox.getSelectedItem();
        if (fullText.trim().isEmpty() || languageParam == null || selectedSpeakerItem == null) {
            String appendToLog = this.appendToLog("\u9519\u8bef: \u6587\u672c\u8f93\u5165\u3001\u8bed\u8a00\u6216\u6717\u8bfb\u8005\u9009\u62e9\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            this.writeLogToFile(appendToLog);
            this.synthesizeButton.setEnabled(true);
            return;
        }
        String speakerValue = selectedSpeakerItem.getValue();
        if (speakerValue.isEmpty()) {
            String appendToLog = this.appendToLog("\u9519\u8bef: \u5f53\u524d\u8bed\u8a00\u65e0\u53ef\u7528\u6717\u8bfb\u8005\u3002");
            this.writeLogToFile(appendToLog);
            this.synthesizeButton.setEnabled(true);
            return;
        }
        new Thread(() -> {
            boolean overallSuccess = true;
            StringBuilder sessionLog = new StringBuilder();
            if (this.currentMode == Mode.SIMPLE) {
                String text = fullText.trim();
                if (text.isEmpty()) {
                    String appendToLog = this.appendToLog("\u9519\u8bef: \u7b80\u5355\u6a21\u5f0f\u4e0b\uff0c\u6587\u672c\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a\u3002");
                    this.writeLogToFile(appendToLog);
                    overallSuccess = false;
                } else {
                    String appendToLog = this.appendToLog("--- \u542f\u52a8\u7b80\u5355\u6a21\u5f0f\u5408\u6210 (\u603b\u5b57\u7b26\u6570: " + text.length() + ") ---");
                    this.writeLogToFile(appendToLog);
                    this.sendTtsRequestSync(text, accessKey, languageParam, speakerValue, -1, sessionLog);
                }
            } else {
                String[] rawLines;
                ArrayList<String> lines = new ArrayList<String>();
                for (String line : rawLines = fullText.split("\\r?\\n")) {
                    String trimmedLine = line.trim();
                    if (trimmedLine.isEmpty()) continue;
                    lines.add(trimmedLine);
                }
                if (lines.isEmpty()) {
                    appendToLog = this.appendToLog("\u9519\u8bef: \u6279\u91cf\u6a21\u5f0f\u4e0b\uff0c\u672a\u627e\u5230\u6709\u6548\u6587\u672c\u884c\u3002");
                    this.writeLogToFile(appendToLog);
                    overallSuccess = false;
                } else {
                    appendToLog = this.appendToLog("--- \u542f\u52a8\u6279\u91cf\u6a21\u5f0f\u5408\u6210 (\u603b\u884c\u6570: " + lines.size() + ") ---");
                    this.writeLogToFile(appendToLog);
                    for (int i = 0; i < lines.size(); ++i) {
                        String lineText = (String)lines.get(i);
                        this.sendTtsRequestSync(lineText, accessKey, languageParam, speakerValue, i, sessionLog);
                    }
                }
            }
            SwingUtilities.invokeLater(() -> {
                this.writeLogToFile(sessionLog.toString());
                this.synthesizeButton.setEnabled(true);
                String appendToLog = this.appendToLog("--- \u5408\u6210\u4efb\u52a1\u5b8c\u6210 ---");
                this.writeLogToFile(appendToLog);
            });
        }).start();
    }

    private String appendToLog(String message) {
        String formattedMessage = message + "\n";
        SwingUtilities.invokeLater(() -> {
            this.logTextArea.append(formattedMessage);
            this.logTextArea.setCaretPosition(this.logTextArea.getDocument().getLength());
        });
        return formattedMessage;
    }

    public static void main(String[] args2) {
        Font fileChooserFont = new Font("Microsoft YaHei", 0, 12);
        try {
            UIManager.put("FileChooser.fileNameFont", fileChooserFont);
            UIManager.put("FileChooser.folderNameFont", fileChooserFont);
            UIManager.put("FileChooser.listViewFont", fileChooserFont);
            UIManager.put("Button.font", fileChooserFont);
            UIManager.put("Label.font", fileChooserFont);
            UIManager.put("ComboBox.font", fileChooserFont);
            UIManager.put("List.font", fileChooserFont);
            UIManager.put("TextField.font", fileChooserFont);
            UIManager.put("TextPane.font", fileChooserFont);
            UIManager.put("TextArea.font", fileChooserFont);
            UIManager.put("TitledBorder.font", fileChooserFont);
            UIManager.put("Table.font", fileChooserFont);
            UIManager.put("TableHeader.font", fileChooserFont);
            UIManager.put("Panel.font", fileChooserFont);
        }
        catch (Exception e) {
            System.err.println("\u8bbe\u7f6e UIManager \u5b57\u4f53\u5931\u8d25: " + e.getMessage());
        }
        SwingUtilities.invokeLater(() -> {
            if (!Desktop.isDesktopSupported()) {
                System.err.println("\u8b66\u544a: \u5f53\u524d\u73af\u5883\u4e0d\u652f\u6301 Java Desktop API\uff0c\u94fe\u63a5\u53ef\u80fd\u65e0\u6cd5\u81ea\u52a8\u6253\u5f00\u3002");
            }
            new TtsSynthesizerApp().setVisible(true);
        });
    }

    private static enum Mode {
        SIMPLE,
        BATCH;

    }

    private static class SpeakerItem {
        private final String displayName;
        private final String value;

        public SpeakerItem(String displayName, String value) {
            this.displayName = displayName;
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return this.displayName;
        }
    }
}

