#!/bin/bash

# 设置窗口标题（仅在某些终端有效）
echo -e "\033]0;TTS Synthesizer App Launcher\007"
echo "正在启动 TTS Synthesizer App..."

# ----------------------------------------------------
# 获取当前脚本所在目录
# ----------------------------------------------------
# BASH_SOURCE[0] 是脚本自身的文件名
# dirname $0 获取脚本所在目录
DIR="$( cd "$( dirname "${BASH_SOURCE[0]}" )" &> /dev/null && pwd )"
JAR_PATH="$DIR/TtsSynthesizerApp.jar"

# 检查 JAR 文件是否存在
if [ ! -f "$JAR_PATH" ]; then
    echo "错误: 找不到 JAR 文件 $JAR_PATH"
    exit 1
fi

# 启动 Java 应用程序
java -jar "$JAR_PATH"

# 检查 Java 退出状态
if [ $? -ne 0 ]; then
    echo ""
    echo "-----------------------------------------------------------------"
    echo "警告: 启动失败!"
    echo "请确认以下事项:"
    echo "1. 系统中是否安装了 Java Runtime Environment (JRE 17 或更高版本)"
    echo "2. 'java' 命令是否在系统的 PATH 中"
    echo "3. JAR 文件路径是否正确"
    echo "-----------------------------------------------------------------"
fi

echo "脚本执行完毕。"